# Test_OLG
# Copyright 2005 by Brian Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Change log:
# 050305 - first draft
# 050311 - got it working
# 050312 - intercept drag event, save and use the node positions
# 060818 - make more room for the task number so it won't be truncated (on Windows)

import wx
import wx.lib.ogl as ogl

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

class Node(ogl.DividedShape):
    def __init__(self, width, height, canvas, type="", label=""):
        ogl.DividedShape.__init__(self, width, height)

        region1 = ogl.ShapeRegion()
        region1.SetText(type)
        # region1.SetProportions(0.0, 0.25)
        region1.SetProportions(0.0, 0.30)
        region1.SetFormatMode(ogl.FORMAT_CENTRE_HORIZ|ogl.FORMAT_CENTRE_VERT)
        self.AddRegion(region1)

        region2 = ogl.ShapeRegion()
        region2.SetText(label)
        region2.SetProportions(0.0, 0.75)
        region2.SetFormatMode(ogl.FORMAT_CENTRE_HORIZ|ogl.FORMAT_CENTRE_VERT)
        self.AddRegion(region2)

#        region3 = ogl.ShapeRegion()
#        region3.SetText('Note')
#        region3.SetProportions(0.0, 0.1)
#        region3.SetFormatMode(ogl.FORMAT_NONE)
#        self.AddRegion(region3)

        self.SetRegionSizes()
        self.ReformatRegions(canvas)

    def ReformatRegions(self, canvas=None):
        rnum = 0

        if canvas is None:
            canvas = self.GetCanvas()

        dc = wx.ClientDC(canvas)  # used for measuring

        for region in self.GetRegions():
            text = region.GetText()
            self.FormatText(dc, text, rnum)
            rnum += 1

#    def OnSizingEndDragLeft(self, pt, x, y, keys, attch):
#        print "***", self
#        self.base_OnSizingEndDragLeft(pt, x, y, keys, attch)
#        self.SetRegionSizes()
#        self.ReformatRegions()
#        self.GetCanvas().Refresh()

class NodeHandler(ogl.ShapeEvtHandler):
    """
    Overwrite the default event handler to implement some custom features. 
    """
    def __init__(self):
        ogl.ShapeEvtHandler.__init__(self)

    def OnEndDragLeft(self, x, y, keys = 0, attachment = 0):
        """
        The dragging is done here. 
        You should probably comment out the EVT_MOTION below, to see it work. 
        """
        shape = self.GetShape()
        ogl.ShapeEvtHandler.OnEndDragLeft(self, x, y, keys, attachment)
        if debug: print "OnEndDragLeft", shape.__class__, shape.GetClassName(), shape.rowid
        if debug: print "x ", x, " y ", y
        change = { 'Table': 'ReportRow', 'ID': shape.rowid, 'NetDiagX': x, 'NetDiagY': y }
        Data. Update(change, 0)  # not undo-able
        # Data.SetUndo('Move Node')
 
    def OnLeftClick(self, x, y, keys = 0, attachment = 0):
        """
        The dragging is done here. 
        You should probably comment out the EVT_MOTION below, to see it work. 
        """
        shape = self.GetShape()
        print "OnLeftClick", shape.__class__, shape.GetClassName(), shape
#        print shape.__class__, shape.GetClassName(), shape.a
#        canvas = shape.GetCanvas()
#        dc = wxClientDC(canvas)
#        canvas.PrepareDC(dc)

#        if shape.Selected():
#            shape.Select(False, dc)
#            canvas.Redraw(dc)
#        else:
#            redraw = False
#            shapeList = canvas.GetDiagram().GetShapeList()
#            toUnselect = []
#            for s in shapeList:
#                if s.Selected():
#                    toUnselect.append(s)

#            shape.Select(True, dc)

#            if toUnselect:
#                for s in toUnselect:
#                    s.Select(False, dc)
#                canvas.Redraw(dc)

class NetworkCanvas(ogl.ShapeCanvas):
    global Node, NodeHandler
    def __init__(self, parent, frame, reportid=0):
        ogl.ShapeCanvas.__init__(self, parent)

        self.SetBackgroundColour( "LIGHT BLUE" ) #

        diagram = ogl.Diagram()
        self.SetDiagram( diagram )
        diagram.SetCanvas( self )

        # database pointers
        dr = Data.Database['Report']
        drt = Data.Database['ReportType']
        drr = Data.Database['ReportRow']
        dt = Data.Database['Task']
        dd = Data.Database['Dependency']

        nodeW = 90
        nodeH = 75

        minX = 0
        minY = 0
        maxX = 1000
        maxY = 1000
        rows = Data.GetRowList(reportid)
        tasks = {}
        links = {}
        for rid in rows:
            if drr[rid].get('Hidden'): continue
            table = drr[rid].get('TableName')
            id = drr[rid].get('TableID')
            # make sure canvas is large enough to contain all objects
            x = drr[rid].get('NetDiagX')
            y = drr[rid].get('NetDiagX')
            if x:
                if x < minX: minX = x - nodeW
                if x > maxX: maxX = x + nodeW
            if y:
                if y < minY: minY = y - nodeH
                if y > maxY: maxY = y + nodeH
            active = table and id and (Data.Database[table][id].get('zzStatus', 'active') == 'active')
            if not active: continue
            if table == 'Task': 
                tasks[id] = rid
            else:
                links[id] = Data.Database[table][id]

        # need to decide how large to make the canvas
        self.SetScrollbars(20, 20, (maxX-minX)/20, (maxY-minY)/20)

        for k in links.keys():
            if tasks.has_key(links[k].get('TaskID')) and tasks.has_key(links[k].get('PrerequisiteID')):
                pass
            else:
                del links[k]

        # nodes
        self.shapes = []

#        shape = ogl.CircleShape( 20.0 )              #
#        shape.SetX( 25.0 )                         #
#        shape.SetY( 25.0 )                         #
#        canvas.AddShape( shape )                   #
#        self.shapes.append(shape)

        increment = 110
        width = increment * 5
        offset = 0
        for k, v in tasks.iteritems():
            type = 'Task:' + str(k) 
            label = dt[k].get('Name')
            # shape2 = Node(90, 70, self, type=type, label=label)  # w, h
            shape2 = Node(90, 75, self, type=type, label=label)  # w, h
            oldx = drr[v].get('NetDiagX')
            oldy = drr[v].get('NetDiagY')
            if oldx:
                shape2.SetX( oldx - minX )
            else:
                shape2.SetX( 60.0 + offset % width ) 
            if oldy:
                shape2.SetY( oldy - minY)
            else:
                shape2.SetY( 50.0 + offset / width * 80 )
            shape2.rowid = v

            self.AddShape( shape2 )                   #
            tasks[k] = shape2
            offset += increment

            self.evthandler = NodeHandler()
            self.evthandler.SetShape(shape2)
            self.evthandler.SetPreviousHandler(shape2.GetEventHandler())
            shape2.SetEventHandler(self.evthandler)

        # arrows

        dc = wx.ClientDC(self)
        self.PrepareDC(dc)

        for k, v in links.iteritems():
            p = v.get('PrerequisiteID')
            fromShape = tasks[p]
            s = v.get('TaskID')
            toShape = tasks[s]

            line = ogl.LineShape()
            line.SetCanvas(self)
            line.SetPen(wx.BLACK_PEN)
            line.SetBrush(wx.BLACK_BRUSH)
            line.AddArrow(ogl.ARROW_ARROW)
            line.MakeLineControlPoints(2)
            fromShape.AddLine(line, toShape)
            self.AddShape(line)
            line.Show(True)

            # for some reason, the shapes have to be moved for the line to show up...
            fromShape.Move(dc, fromShape.GetX(), fromShape.GetY())

        # end of arrows

        diagram.ShowAll( 1 )                       #

#        wx.EVT_MOTION(self, self.OnMotion)

    def OnMotion(self, event):
#        shape = self.evthandler.GetShape()

#        bx = shape.GetX()
#        by = shape.GetY()
#        bw, bh = shape.GetBoundingBoxMax()
#        oldrect = wx.Rect(int(bx-bw/2)-1, int(by-bh/2)-1, int(bw)+2, int(bh)+2)

#        canvas = shape.GetCanvas()
#        dc = wx.ClientDC(canvas)
#        canvas.PrepareDC(dc)

#        shape.Move(dc, event.GetPosition()[0], event.GetPosition()[1])
#        canvas.Refresh(False, oldrect)
        if debug: print '---- onMotion ----'
        event.Skip()

class AppFrame(wx.Frame):
    global NetworkCanvas
    def __init__(self, reportid=0):
        pid = Data.Database['Report'][reportid].get('ProjectID')
        project = Data.Database['Project'][pid].get('Name') or "(unnamed)"
        wx.Frame.__init__( self,
                          None, -1, "Network Diagram for " + project,
                          size=(600,400),
                          style=wx.DEFAULT_FRAME_STYLE)
#        self.SetTitle("OGL TEST")
#        self.SetBackgroundColour(wxColour(8, 197, 248))

        sizer = wx.BoxSizer( wx.VERTICAL )
        # put stuff into sizer

        self.canvas = NetworkCanvas( self, self, reportid=reportid )
        sizer.Add( self.canvas, 1, wx.GROW )

        # apply sizer
        self.SetSizer(sizer)
        self.SetAutoLayout(1)
        self.Show(1)

if __name__ == "__main__":
    app = wx.PySimpleApp()
    ogl.OGLInitialize()
    frame = AppFrame()
    app.MainLoop()

else:

    ogl.OGLInitialize()
    reportid = self.ReportID
    rtid = Data.Database['Report'][reportid]['ReportTypeID']
    rtype = Data.Database['ReportType'][rtid].get('Name')
    if rtype == 'Task/Dependency':
        frame = AppFrame(reportid=reportid)
    else:
        hint('Only for Task/Dependency Reports')
